<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
<div class="page-background">
    <!-- Floating Elements Background -->
    <div class="floating-shapes">
        <div class="shape shape-1 animate-float"></div>
        <div class="shape shape-2 animate-float-slow"></div>
        <div class="shape shape-3 animate-float"></div>
        <div class="shape shape-4 animate-float-slow"></div>
        <div class="shape shape-5 animate-float"></div>
        <div class="shape shape-6 animate-float-slow"></div>
    </div>
<div class="container container-with-shapes py-5">
    <h1 class="section-title mb-4">
        <i class="bi bi-people me-2"></i>Organisasi
    </h1>



    <!-- Organizations Timeline -->
    <?php if (empty($organizations)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada organisasi yang ditemukan.
        </div>
    <?php else: ?>
        <div class="education-timeline">
            <?php foreach ($organizations as $org): ?>
                <div class="education-item">
                    <div class="d-flex justify-content-between align-items-start mb-2">
                        <div>
                            <h4 class="mb-1">
                                <i class="bi bi-people-fill me-2 text-primary"></i>
                                <?= esc($org['nama_organisasi']) ?>
                            </h4>
                            <?php if ($org['jabatan']): ?>
                                <p class="text-white mb-2">
                                    <i class="bi bi-person-badge me-1"></i><?= esc($org['jabatan']) ?>
                                </p>
                            <?php endif; ?>
                        </div>
                        <div class="text-end">
                            <?php if ($org['tahun_mulai'] && $org['tahun_selesai']): ?>
                                <p class="mb-0 text-white">
                                    <i class="bi bi-calendar-range me-1"></i>
                                    <?= esc($org['tahun_mulai']) ?> - <?= esc($org['tahun_selesai']) ?>
                                </p>
                            <?php elseif ($org['tahun_mulai']): ?>
                                <p class="mb-0 text-white">
                                    <i class="bi bi-calendar me-1"></i>
                                    Mulai: <?= esc($org['tahun_mulai']) ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php if ($org['deskripsi']): ?>
                        <p class="text-white mb-0"><?= nl2br(esc($org['deskripsi'])) ?></p>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <!-- Pagination -->
        <?php if (isset($lastPage) && $lastPage > 1): ?>
            <nav aria-label="Page navigation" class="mt-5">
                <ul class="pagination justify-content-center">
                    <?php if ($currentPage > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('organizations?page=' . ($currentPage - 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i> Sebelumnya
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $lastPage; $i++): ?>
                        <li class="page-item <?= $i == $currentPage ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('organizations?page=' . $i . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Part <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($currentPage < $lastPage): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('organizations?page=' . ($currentPage + 1) . '&search=' . urlencode($search) . '&tahun_mulai=' . urlencode($filter['tahun_mulai']) . '&tahun_selesai=' . urlencode($filter['tahun_selesai']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Selanjutnya <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
</div>
<?= $this->endSection() ?>

